CREATE TABLE Empresas_Sedes_Sec_Turnos (
	Id_Sector_Turno	INT IDENTITY(1,1) NOT NULL,
	Id_Sector			SMALLINT,
	Descripcion			VARCHAR(100),
	Id_Tipo_Cbte		CHAR(4),
	Id_Producto			VARCHAR(14),
	Duracion			INT,
	Activo				TINYINT,
	CONSTRAINT PK_ESSRT_PorId PRIMARY KEY CLUSTERED (Id_Sector_Turno)
)
GO

CREATE INDEX IX_ESST_PorRec ON Empresas_Sedes_Sec_Turnos (Id_Sector)
GO

CREATE INDEX IX_ESST_PorCbte ON Empresas_Sedes_Sec_Turnos (Id_Tipo_Cbte)
GO

CREATE INDEX IX_ESST_PorProd ON Empresas_Sedes_Sec_Turnos (Id_Producto)
GO


ALTER TABLE Empresas_Sedes_Sec_Turnos  WITH CHECK ADD  CONSTRAINT FK_ESST_Sectores FOREIGN KEY(Id_Sector)
REFERENCES Empresas_Sedes_Sectores (Id_Sector)
GO


ALTER TABLE Empresas_Sedes_Sec_Turnos  ADD  CONSTRAINT FK_ESST_Cbtes_Tipos FOREIGN KEY(Id_Tipo_Cbte)
REFERENCES Cbtes_Tipos (Id_Tipo_Cbte)
GO

ALTER TABLE Empresas_Sedes_Sec_Turnos  WITH CHECK ADD  CONSTRAINT FK_ESST_Productos FOREIGN KEY(Id_Producto)
REFERENCES Productos (Id_Producto)
GO







